-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.hero:LinkToTarget("defeat")
	  player = Citadels.GetPlayer(0)
	  player:SetUnitNameToUnit(Game:GetEntity('hero'), 'unit_D_earlragnall_L1')
  end
end

function OnBeforeDeath(self)
  self.hero:TriggerAllTargets()
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
  end
end

function CreateTriggerSources(self)
  self:AddTriggerSource("hero")
end
